// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for viewing the contents of a Tsc
// encrypted file.
//...............................................
#define	BLOCK_SIZE	16

#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include <math.h>
#include <stdio.h>
#include "Tscmsg.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	BOOL				bIsWin9x;
extern	HINSTANCE			hInst;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpEncFileIcon;
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	HWND				hMainWindow;
extern	DWORD				dwOldHelpNumber;
extern	BOOL				bSendersRegistered;
extern	HWND				hViewWindow;
extern	HWND				hEditWindow;
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer2;
extern	BOOL				bScrollWnd;
extern	BOOL				bSizeWnd;
extern	int					xClient;
extern	int					yClient;
extern	int					xClientMax;
extern	int					xChar;
extern	int					yChar;
extern	int					xPos;
extern	int					yPos;
extern	int					xMax;
extern	int					yMax;
extern	int					xInc;
extern	int					yInc;
extern	int					iTotalLines;
extern	RECT				BitMapRect;
extern	SCROLLINFO			sci;
extern	PAINTSTRUCT			ps;
extern	HDC					hDC;
extern	HDC					hCompatDC;
extern	HBITMAP				hbm;
extern	TEXTMETRIC			tm;
extern	BOOL				bViewWindowDisplayed;
extern	BOOL				bEditWindowDisplayed;
extern	SYSTEMTIME			stCreated;
extern	TCHAR				szTime;				// Time format.
extern	LPCTSTR				lpszName;			// = File Name:
extern	BYTE				KeySID;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	LPBYTE				lpIndexFile1;
extern	HANDLE				hIdxHandle1;
extern	DWORD				dwIdxOffset1;
extern	TCHAR				TimeSep;
extern	HWND				hEditListWindow;
extern	DWORD				dwProcedure;
extern	LPBYTE				lpKeyBufferDup1;

// A couple of local macros.
//..........................
#define Col(x) (x * xChar)
#define Line(y) (y * yChar)

// Define the BHEX instruction that changes a hex value
// in al into two hex digits in ah and al.
//.....................................................
#define	BHEX __asm _emit 0xd4 __asm _emit 0x10

// Variables for use by view procedures.
//......................................
TCHAR			szTscFile[MAX_PATH];
LPBYTE			lpTscFileName;
HANDLE			hTscFile;
HANDLE			hSendersEvent;
HANDLE			hSendersOpen;
DWORD			dwLineCount;
DWORD			dwLastLine;
DWORD			dwCharOnLastLine;
DWORD			dwCharInLine;
LPCTSTR			lpszTscSenders = "TSCSENDERS";
LPCTSTR			lpszTscContents = "TSCCONTENTS";
LPCTSTR			lpszSenders = "Senders and Recipients";
TCHAR			szSentBy[] = "This encrypted file was sent by:";
TCHAR			szSentTo[] = "This encrypted file was sent to:";
TCHAR			szNoMatchSender[] = "No match for Sender's Key on our Public Key Ring.";
TCHAR			szNoMatchRecipient[] = "No match for this recipient on our Our Public Key Ring.";
TCHAR			szSendersTimestamp[] = "This encrypted file was created on                  at          GMT.";
TCHAR			szBuffer[80];

// View the contents of a tsc encrypted file.
//...........................................
VOID ViewTscFile()
{
	LARGE_INTEGER	li;
	LARGE_INTEGER	liMax;
	OPENFILENAME	ofn;
	int				iResult;
	TCHAR			szFormat[128];
	TCHAR			szOutBuffer[512];
	RECT			rect;

	if (dwProcedure == IDM_ENC_VIEW)
	{
		bProcessInProgress = TRUE;
		dwOldHelpNumber = ChangeHelpTopic(IDH_VIEWTSCFILE);
	}
	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);

	if (BPC())
	{
		goto ViewEnd;
	}
	// Initialize with specific information for this procedure.
	//.........................................................
	ofn.lpstrFile = szTscFile;
	ofn.nMaxFile = sizeof(szTscFile);
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Tscg Encrypted Files [.tsc]\0*.tsc\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.lpstrTitle = TEXT("Select an Encrypted File to View");
	ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
		         OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY | OFN_SHOWHELP);
	ofn.lpstrDefExt = NULL;
	ofn.lpfnHook = MyOFNHookProc;

	// Setup the icon to use in the caption bar.
	//..........................................
	lpIconPointer = lpszAppName;

	if (dwProcedure == IDM_ENC_VIEW)
	{
		while(TRUE)
		{
			// Now select an encrypted file to view the contents of.
			//......................................................
			ZeroMemory(&szTscFile,sizeof(szTscFile));

			if (!GetOpenFileName(&ofn))
			{
				CommDlgBoxErrorProc(IDS_GET_FILES);
				goto ViewEnd;
			}
			SaveDirName((LPBYTE)&szTscFile,SAVE_SOURCE,TRUE);

			// Check out the file. It has to be a valid tsc encrypted file.
			// Returns a pointer to the cke packet if valid.
			//.............................................................
			li.QuadPart = IsTscFileValid((LPBYTE)&szTscFile);

			if (li.QuadPart == -1)
			{
				SetLastError(IDS_NOTVALIDTSCFILE);
				ErrorProcedure((LPTSTR)&szTscFile,IDS_CREATE_OPEN,MB_OK);
				continue;
			}
			break;
		}
	}
	// Get a pointer to the file name.
	//................................
	lpTscFileName = PathFindFileName((LPCTSTR)&szTscFile);
	EmptyTheMessageQue();

	// We have a valid tsc encrypted file. Ask if we want to view
	// the sender and recipients.
	//...........................................................
	if (bSendersRegistered)
	{
		LoadString(hInst,IDS_TSCVIEWFILE,(LPTSTR)&szFormat,
				   sizeof(szFormat));
		StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormat,
						lpTscFileName);
		iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szOutBuffer,
							     MB_ICONQUESTION | MB_YESNOCANCEL | MB_HELP,
								 MB_ICONQUESTION,0);
		if (iResult == IDCANCEL)
		{
			goto ViewEnd;
		}
		if (iResult == IDYES)
		{
			// Create our event for the view senders and recipients
			// window.
			//..................................................
			hSendersEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("SendersEvent"));
			if (!hSendersEvent)
			{
				ErrorProcedure(TEXT("SendersEvent"),IDS_CREATEEVENT,MB_OK);
				goto ViewEnd;
			}
			// Create the window to display the senders and 
			// recipients in.
			//..............................................
			GetClientRect(hMainWindow,&rect);

			// Create the window for viewing senders and recipients.
			//......................................................
			hViewWindow = CreateWindowEx(WS_EX_CLIENTEDGE,lpszTscSenders,
										 lpszSenders,WS_CAPTION | 
										 WS_CHILD |WS_SYSMENU | 
										 WS_HSCROLL | WS_VSCROLL | 
										 WS_VISIBLE | WS_CLIPCHILDREN,
										 rect.left,rect.top+37,rect.right,
										 rect.bottom-59,hMainWindow,NULL,
										 hInst,NULL);
			if (!hViewWindow)
			{
				ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
				goto ViewEnd;;
			}
			SetFocus(hViewWindow);

			// Open the event object.
			//.......................
			hSendersOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("SendersEvent"));
			if (!hSendersOpen)
			{
				DestroyWindow(hViewWindow);
				goto ViewEnd;
			}
			// We have to wait for the Edit Event to become signaled 
			// before we can return and view the contents of the tsc
			// encrypted file.
			//......................................................
			while(TRUE)
			{
				if (WaitForSingleObject(hSendersEvent,0) == WAIT_OBJECT_0)
				{
					break;
				}
				EmptyTheMessageQue();
			}
		}
	}
	if (hSendersOpen)
	{
		CloseHandle(hSendersOpen);
		hSendersOpen = 0;
	}
	if (hSendersEvent)
	{
		CloseHandle(hSendersEvent);
		hSendersEvent = 0;
	}
	// Allocate a buffer to be used by the view procedure.
	//....................................................
	lpKeyBuffer1 = AllocateMemory(128);
	if (!lpKeyBuffer1)
	{
		goto ViewEnd;
	}
	// Open the tsc encrypted file and determine its size.
	//....................................................
	hTscFile = CreateMyFile((LPTSTR)&szTscFile,GENERIC_READ,0,NULL,
							 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hTscFile)
	{
		goto ViewEnd;
	}
	li.QuadPart = GetMyFileSize((LPTSTR)&szTscFile,hTscFile);
	if (li.QuadPart == -1)
	{
		goto ViewEnd;
	}
	// Setup the maximum number of bytes in a tsc encrypted file
	// we can handle.
	//..........................................................
	__asm
	{
		xor		edx,edx
		mov		eax,-1
		mov		ecx,BLOCK_SIZE
		mul		ecx
		mov		liMax.LowPart,eax
		mov		liMax.HighPart,edx
	}
	if (li.QuadPart > liMax.QuadPart)
	{
		dwLineCount = 4294967295;
		dwCharOnLastLine = BLOCK_SIZE;
	}
	else
	{
		__asm
		{
			mov		edx,li.HighPart
			mov		eax,li.LowPart
			mov		ecx,BLOCK_SIZE
			div		ecx
			mov		dwLineCount,eax
			mov		dwCharOnLastLine,edx
		}
		if (dwCharOnLastLine == 0)
		{
			dwCharOnLastLine = BLOCK_SIZE;
		}
		else
		{
			dwLineCount++;
		}
	}
	dwLastLine = (dwLineCount - 1);

	// Create our event for viewing the contents of the
	// tsc encrypted file.
	//.................................................
	hSendersEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("SendersEvent"));
	if (!hSendersEvent)
	{
		ErrorProcedure(TEXT("SendersEvent"),IDS_CREATEEVENT,MB_OK);
		goto ViewEnd;
	}
	// Create the window to display the tsc encrypted file contents in.
	// Use hEditWindow and bEditWindowDisplayed
	//.................................................................
	GetClientRect(hMainWindow,&rect);

	hEditWindow = CreateWindowEx(0,lpszTscContents,lpszNullString,
								 WS_CAPTION | WS_CHILD | WS_SYSMENU | 
								 WS_VISIBLE | WS_CLIPCHILDREN,
								 rect.left,rect.top+37,
								 rect.right,rect.bottom-59,
								 hMainWindow,NULL,hInst,NULL);

	if (!hEditWindow)
	{
		ErrorProcedure(lpszNA,IDS_CREATEWINEX,MB_OK);
		goto ViewEnd;
	}
	// Open the event object.
	//.......................
	hSendersOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("SendersEvent"));
	if (!hSendersOpen)
	{
		DestroyWindow(hEditWindow);
		goto ViewEnd;
	}
	// We have to wait for the Edit Event to become signaled 
	// before we can return.
	//......................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hSendersEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}

	ViewEnd:

	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,128);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (hSendersOpen)
	{
		CloseHandle(hSendersOpen);
		hSendersOpen = 0;
	}
	if (hSendersEvent)
	{
		CloseHandle(hSendersEvent);
		hSendersEvent = 0;
	}
	if (hTscFile)
	{
		CloseMyHandle((LPTSTR)&szTscFile,hTscFile);
		hTscFile = 0;
	}
	if(dwProcedure == IDM_ENC_VIEW)
	{
		ChangeHelpTopic(dwOldHelpNumber);
		bProcessInProgress = FALSE;
	}
}

// Setup the senders and recipients of an encrypted file.
//.......................................................
BOOL SetupSendersRecipients()
{
	LARGE_INTEGER	liSkeTimestamp;
	LARGE_INTEGER	li;
	BOOL			bResult;
	int				iSendersLine;
	int				iTimestampLine;
	int				iPrintLine;
	DWORD			dwBytesRead;
	DWORD			dwBytesToRead;
	DWORD			dwCtb_Byte;
	DWORD			dwUserIdLength;
	LPBYTE			lpTempEDI;
	BOOL			bFinalResult = FALSE;
	BYTE			TypePacket;
	BYTE			Line1[32];
	BYTE			CtbByte;

	// Fill the rectangle with a white background.
	//............................................
	FillRect(hCompatDC,&BitMapRect,(HBRUSH)(COLOR_WINDOW+1));
	SelectObject(hCompatDC,GetStockObject(NULL_BRUSH));
	SetBkColor(hCompatDC,GetSysColor(COLOR_WINDOW));

	iTotalLines = 1;
	
	// Print the file name.
	//.....................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),lpszName,lstrlen(lpszName));
	iTotalLines++;
	SetTextColor(hCompatDC,RGB(210,0,0));
	if (lstrlen(lpTscFileName) > 78)
	{
		TextOut(hCompatDC,Col(1),Line(iTotalLines),lpTscFileName,78);
	}
	else
	{
		TextOut(hCompatDC,Col(1),Line(iTotalLines),lpTscFileName,lstrlen(lpTscFileName));
	}
	iTotalLines += 2;

	// Print some of the header lines.
	//................................
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),(LPCTSTR)&szSentBy,lstrlen(szSentBy));
	iSendersLine = (iTotalLines + 2);
	iTotalLines += 4;
	SetTextColor(hCompatDC,RGB(0,0,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),(LPCTSTR)&szSendersTimestamp,
			lstrlen(szSendersTimestamp));
	iTimestampLine = iTotalLines;
	iTotalLines += 2;
	SetTextColor(hCompatDC,RGB(0,128,0));
	TextOut(hCompatDC,Col(1),Line(iTotalLines),(LPCTSTR)&szSentTo,lstrlen(szSentTo));
	iTotalLines += 2;

	// Allocate the memory for the buffers.
	//.....................................
	lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	if (!lpKeyBuffer1 || !lpKeyBuffer2)
	{
		goto SetupEnd;
	}
	// Setup the key ring index files.
	//................................
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_ONE);
	SetUpGroup(SECRET_KEY,INDEX_KEY,GROUP_TWO);

	// Open the tsc encrypted file.
	//.............................
	hTscFile = CreateMyFile((LPTSTR)&szTscFile,GENERIC_READ,0,NULL,
							 OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hTscFile)
	{
		goto SetupEnd;
	}
	// Process the encrypted file in a loop.
	//......................................
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)&szTscFile,hTscFile,lpKeyBuffer2,1,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto SetupEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		__asm
		{
			mov		edi,lpKeyBuffer2
			mov		al,byte ptr [edi]
			mov		cl,al
			and		al,CTB_MASK
			mov		TypePacket,al

			// Determine the length of the length field.
			//..........................................
			mov		edx,1
			and		cl,LENGTH_MASK
			shl		edx,cl
			mov		dwBytesToRead,edx
		}
		// Read in the length field.
		//..........................
		bResult = ReadMyFile((LPTSTR)&szTscFile,hTscFile,lpKeyBuffer2,
							  dwBytesToRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto SetupEnd;
		}
		if (dwBytesToRead != dwBytesRead)
		{
			goto SetupEnd;
		}
		// Get the length of this packet.
		//...............................
		__asm
		{
			mov		edi,lpKeyBuffer2
			cmp		dwBytesRead,1
			jne		L1
			movzx	ecx,byte ptr [edi]
			jmp		L3
		L1:	cmp		dwBytesRead,2
			jne		L2
			movzx	ecx,word ptr [edi]
			xchg	ch,cl
			jmp		L3
		L2:	mov		ecx,dword ptr [edi]
			bswap	ecx
		L3:	mov		dwBytesToRead,ecx
		}
		// Read in the rest of the packet.
		//................................
		bResult = ReadMyFile((LPTSTR)&szTscFile,hTscFile,lpKeyBuffer2,
							  dwBytesToRead,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto SetupEnd;
		}
		if (dwBytesToRead != dwBytesRead)
		{
			goto SetupEnd;
		}
		// Setup edi to point to the key id in the pke or ske packet.
		//...........................................................
		if (TypePacket == CTB_PKE_PACKET)
		{
			lpTempEDI = lpKeyBuffer2;
			lpTempEDI++;
		}
		else if (TypePacket == CTB_SKE_PACKET)
		{
			liSkeTimestamp.QuadPart = 0;

			__asm
			{
				mov		edi,lpKeyBuffer2
				add		edi,(VERSION_SIZE + 2)
				mov		eax,dword ptr [edi]
				bswap	eax
				mov		liSkeTimestamp.LowPart,eax

				// Get the high order 7 bits of the timestamp.
				//............................................
				mov		eax,dword ptr [edi+12]
				and		eax,0x00ff
				shr		eax,1
				mov		liSkeTimestamp.HighPart,eax
				add		edi,TIMESTAMP_SIZE
				mov		lpTempEDI,edi
			}
		}
		else
		{
			break;
		}
		// Get the key id for our search of the public key ring.
		//......................................................
		__asm
		{
			mov		edi,lpTempEDI
			mov		eax,dword ptr [edi]
			mov		edx,dword ptr [edi+4]
			mov		dword ptr KeySID,eax
			mov		dword ptr KeySID[4],edx
			add		edi,4
			mov		lpTempEDI,edi
		}
		li.QuadPart = SearchMyFileBinary(lpIndexFile1,&KeySID,KEY_ID_SIZE,hIdxHandle1,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto SetupEnd;
		}
		// Display the short key id for all the keys.
		//...........................................
		ChangeToHex(SHORT_KEY_ID,lpTempEDI,(LPBYTE)&Line1,FORWARD);

		if (TypePacket == CTB_PKE_PACKET)
		{
			iPrintLine = iTotalLines;
		}
		else
		{
			iPrintLine = iSendersLine;
		}
		SetTextColor(hCompatDC,RGB(0,0,0));
		TextOut(hCompatDC,Col(1),Line(iPrintLine),(LPCTSTR)&Line1,lstrlen(Line1));

		// If we have an ske packet calculate the data and time
		// is was created and display it.
		//......................................................
		if (TypePacket == CTB_SKE_PACKET)
		{
			TimestampToDateTime(liSkeTimestamp.QuadPart,&stCreated);

			GetDateFormat(LOCALE_USER_DEFAULT,0,&stCreated,"ddd',' dd MMM yyyy",Line1,32);
			SetTextColor(hCompatDC,RGB(0,0,255));
			TextOut(hCompatDC,Col(36),Line(iTimestampLine),Line1,lstrlen(Line1));

			StringCbPrintf(Line1,sizeof(Line1),&szTime,stCreated.wHour,&TimeSep,
						   stCreated.wMinute,&TimeSep,stCreated.wSecond);
			TextOut(hCompatDC,Col(56),Line(iTimestampLine),Line1,lstrlen(Line1));
		}
		// If we did not have a match on our public key ring 
		// display unknown recipient or sender.
		//..................................................
		if (li.QuadPart == 0)
		{
			SetTextColor(hCompatDC,RGB(0,128,0));
			if (TypePacket == CTB_PKE_PACKET)
			{
				TextOut(hCompatDC,Col(12),Line(iTotalLines),(LPCTSTR)&szNoMatchRecipient,
						lstrlen(szNoMatchRecipient));
			}
			else
			{
				TextOut(hCompatDC,Col(12),Line(iSendersLine),(LPCTSTR)&szNoMatchSender,
					   lstrlen(szNoMatchSender));
			}
			iTotalLines++;
		}
		else
		{
			// We had a match. Get the user id from the public key.
			//.....................................................
			dwIdxOffset1 = li.HighPart;
			dwBytesRead = ReadIndex1();
			if (dwBytesRead == -1)
			{
				goto SetupEnd;
			}
			dwBytesRead = ReadRecord1();
			if (dwBytesRead == -1)
			{
				goto SetupEnd;
			}
			lpKeyBufferDup1 = lpKeyBuffer1;

			// Get the user id.
			//.................
			while(TRUE)
			{
				__asm
				{
					mov		edi,lpKeyBufferDup1
					mov		al,byte ptr [edi]
					mov		cl,al
					mov		dwCtb_Byte,ecx
					and		al,CTB_MASK
					mov		CtbByte,al
				}
				if (CtbByte != CTB_USER_ID)
				{
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						add		edi,eax
						mov		lpKeyBufferDup1,edi
					}
				}
				else
				{
					// We have our user id.
					//.....................
					GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

					__asm
					{
						mov		edi,lpKeyBufferDup1
						add		edi,CTB_SIZE
						add		edi,edx
						mov		dwUserIdLength,eax
						mov		lpKeyBufferDup1,edi
					}
					if (dwUserIdLength > 64)
					{
						dwUserIdLength = 64;
					}
					if (TypePacket == CTB_PKE_PACKET)
					{
						iPrintLine = iTotalLines;
						iTotalLines++;
					}
					else
					{
						iPrintLine = iSendersLine;
					}
					break;
				}
			}
			SetTextColor(hCompatDC,RGB(0,0,255));
			TextOut(hCompatDC,Col(12),Line(iPrintLine),lpKeyBufferDup1,dwUserIdLength);

			// If we have reached our limit of recipients, or
			// the ske packet, bail out.
			//...............................................
			if (iTotalLines >= 200 || TypePacket == CTB_SKE_PACKET)
			{
				break;
			}
		}
	}	// while(TRUE)

	// We have a valid setup.
	//.......................
	bFinalResult = TRUE;

	SetupEnd:

	if (hTscFile)
	{
		CloseMyHandle((LPTSTR)&szTscFile,hTscFile);
		hTscFile = 0;
	}
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	return(bFinalResult);
}

// Register the window class for viewing the contents of a
// tsc encrypted file.
//........................................................
BOOL RegisterTscWindow()
{
	WNDCLASS	wc;

	wc.style		 = 0;
	wc.lpfnWndProc	 = (WNDPROC)TscWndProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst,lpEncFileIcon);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;              
    wc.lpszClassName = lpszTscContents;
	
	if (bIsWin9x)
	{
		if (!RegisterWin95(&wc))
		{
			return(FALSE);
		}
	}
	else if (!RegisterClass(&wc))
	{
		return(FALSE);
	}
	return(TRUE);
}

// Window procedure for viewing the contents of a tsc encrypted
// file.
//...............................................................
LRESULT CALLBACK TscWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
		case WM_CREATE:
		{
			HMENU			hTscWinMenu;
			MENUITEMINFO	mii;

			// Disable the move menu item on the window menu.
			//...............................................
			hTscWinMenu = GetSystemMenu(hWnd,FALSE);

			ZeroMemory(&mii,sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_ID | MIIM_STATE;
			mii.fState = MFS_GRAYED;
			mii.wID = -10;
			SetMenuItemInfo(hTscWinMenu,SC_MOVE,FALSE,&mii);

			// Set the title for the window. Use the title of
			// the tsc encrypted file.
			//...............................................
			SetWindowText(hWnd,(LPCTSTR)lpTscFileName);

			// Setup the virtual list view window.
			//....................................
			hEditListWindow = CreateTscListView(hWnd);
			if (!hEditListWindow)
			{
				return(-1);
			}
			SetFocus(hEditListWindow);
			bEditWindowDisplayed = TRUE;
		}
		break;

		case WM_SYSCOLORCHANGE:
		{
			ListView_SetBkColor(hEditListWindow,GetSysColor(COLOR_WINDOW));			
		}
		break;

		case WM_SIZE:
		{
			// Resize the virtual list view window.
			//.....................................
			ResizeTscListView(GetDlgItem(hWnd,IDC_TSCLISTVIEW),hWnd);
		}
		break;

		case WM_NOTIFY:
		{
			return(EditTscViewNotify(hWnd,(LPNMHDR)lParam));
		}

		case WM_USER:
		{
			SetFocus(hEditListWindow);
		}
		break;

		case WM_CLOSE:
		{
			DestroyWindow(hWnd);
		}
		break;

		case WM_DESTROY:
		{
			// Notify the view procedure that it can continue
			// and exit.
			//...............................................
			SetEvent(hSendersEvent);
			bEditWindowDisplayed = FALSE;
		}
		break;

        default:
			return(DefWindowProc(hWnd, uMsg, wParam, lParam));
	}
	return(0L);
}

// Handle the WM_NOTIFY message for the virtual list view window
// while viewing the contents of a tsc encrypted file.
//..............................................................
LRESULT EditTscViewNotify(HWND hWnd, LPNMHDR lpNmhdr)
{
	LPNMLVDISPINFO		lpLvdi;
	DWORD				dwIndex;
	BOOL				bResult;
	DWORD				dwBytesRead;
	LARGE_INTEGER		li;
	DWORD				dwHighAddress;
	DWORD				dwLowAddress;
	
	switch (lpNmhdr->code)
	{
		case LVN_GETDISPINFO:
		{
			lpLvdi = (LPNMLVDISPINFO)lpNmhdr;

			// Determine the index of the item we need and read
			// it into the buffer. Each block of data is 16 bytes long.
			//.........................................................
			dwIndex = lpLvdi->item.iItem;
			li.QuadPart = (dwIndex * 16);
			li.QuadPart = SetMyFilePointer((LPTSTR)&szTscFile,hTscFile,li.QuadPart,FILE_BEGIN);
			if (li.QuadPart == -1)
			{
				DestroyWindow(hWnd);
			}
			bResult = ReadMyFile((LPTSTR)&szTscFile,hTscFile,lpKeyBuffer1,BLOCK_SIZE,
								  &dwBytesRead,NULL);
			if (!bResult)
			{
				DestroyWindow(hWnd);
			}
			// Fill in the items state. Always 0 for this procedure.
			//......................................................
			if (lpLvdi->item.mask & LVIF_STATE)
			{
				lpLvdi->item.state = 0;
			}
			// Fill in the text for the item and subitems.
			//............................................
			if (lpLvdi->item.mask & LVIF_TEXT)
			{
				switch(lpLvdi->item.iSubItem)
				{
					case 0:
					{
						// Display the address.
						//.....................
						dwHighAddress = LOWORD(li.HighPart);
						dwLowAddress = li.LowPart;
						StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),TEXT("%.2X%.8X"),
									    dwHighAddress,dwLowAddress);
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					case 1:
					{
						dwCharInLine = BLOCK_SIZE;
						if (dwIndex == dwLastLine)
						{
							dwCharInLine = dwCharOnLastLine;
						}
						// Display the hexadecimal text.
						//..............................
						__asm
						{
							mov		esi,lpKeyBuffer1
							mov		edi,offset szBuffer
							mov		edx,0
							mov		ecx,dwCharInLine
						L1:	xor		eax,eax
							lodsb
							BHEX
							add		ax,'00'
							cmp		al,'9'
							jbe		L2
							add		al,7h
						L2:	cmp		ah,'9'
							jbe		L3
							add		ah,7h
						L3:	xchg	ah,al
							stosb
							xchg	ah,al
							stosb
							mov		al,20h
							stosb
							cmp		edx,7
							jne		L4
							stosb
						L4:	inc		edx
							dec		ecx
							jnz		L1
							dec		edi
							mov		al,0
							stosb
						}
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					case 2:
					{
						dwCharInLine = BLOCK_SIZE;
						if (dwIndex == dwLastLine)
						{
							dwCharInLine = dwCharOnLastLine;
						}
						// Display the character text. First we have
						// to change all characters below 20h to 2eh.
						//...........................................
						__asm
						{
							mov		esi,lpKeyBuffer1
							mov		edi,offset szBuffer
							mov		ecx,dwCharInLine
						L5:	xor		eax,eax
							lodsb
							cmp		al,20h
							jb		L6
							cmp		al,7fh
							jb		L7
							cmp		al,91h
							je		L7
							cmp		al,92h
							je		L7
							cmp		al,9fh
							ja		L7
						L6:	mov		al,2eh
						L7:	stosb
							dec		ecx
							jnz		L5
							mov		al,0
							stosb
						}
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									(LPCTSTR)&szBuffer);
					}
					break;

					default:
						break;
				}
			}
		}
		break;

		case LVN_KEYDOWN:
		{
			LPNMLVKEYDOWN		lpKdn;

			lpKdn = (LPNMLVKEYDOWN)lpNmhdr;

			if (lpKdn->wVKey == VK_ESCAPE)
			{
				SendMessage(hWnd,WM_CLOSE,0,0);
			}
		}
		break;

		// We do not select any thing in this virtual window.
		// Just return 0.
		//...................................................
		case LVN_ITEMACTIVATE:
			break;

		// These two messages are not currently used by the program.
		//..........................................................
		case LVN_ODCACHEHINT:
        case LVN_ODFINDITEM:
			break;

		default:
			break;
	}
	return(0);
}

// Create the virtual list view window for viwing our tsc encrypted
// file.
//.................................................................
HWND CreateTscListView(HWND hWndParent)
{
	DWORD       dwStyle;
	HWND        hWndListView;
	LVCOLUMN	lvColumn;
	int			i;
	TCHAR		szColumns[3][16] = {TEXT("Address"),
									TEXT("Hexadecimal"),
									TEXT("Characters")};

	int			iColumnSize[3] = {88,396,144};

	dwStyle =   WS_TABSTOP | 
				WS_CHILD | 
				WS_BORDER | 
				WS_VISIBLE |
				LVS_NOSORTHEADER |
				LVS_REPORT | 
				LVS_OWNERDATA;
	  
	hWndListView = CreateWindowEx(WS_EX_CLIENTEDGE,WC_LISTVIEW,NULL,
                                  dwStyle,0,0,0,0,hWndParent,
                                  (HMENU)IDC_TSCLISTVIEW,hInst,NULL);

	if(!hWndListView)
	{
		return(0);
	}
	// Set the extended styles for the virtual list box.
	//..................................................
	ListView_SetExtendedListViewStyleEx(hWndListView,0,LVS_EX_GRIDLINES);

	SendMessage(hWndListView,WM_SETFONT,(WPARAM)GetStockObject(ANSI_FIXED_FONT),FALSE);

	// Resize the window to fit in the parent windows.
	//................................................
	ResizeEditListView(hWndListView, hWndParent);

	// Set the header columns for the virtual list view window.
	//.........................................................
	lvColumn.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
	for(i = 0; i < 3; i++)
	{
		lvColumn.fmt = LVCFMT_LEFT;
		lvColumn.pszText = szColumns[i];
		lvColumn.cx = iColumnSize[i];
		SendMessage(hWndListView,LVM_INSERTCOLUMN,(WPARAM)i, (LPARAM)&lvColumn);
	}
	// Empty the list.
	//................
	SendMessage(hWndListView,LVM_DELETEALLITEMS,0,0);

	// Set the number of items in the list.
	//.....................................
	SendMessage(hWndListView,LVM_SETITEMCOUNT,(WPARAM)dwLineCount,
			   (LPARAM)LVSICF_NOINVALIDATEALL);

	// Set the callback mask so we can control the state information.
	//...............................................................
	SendMessage(hWndListView,LVM_SETCALLBACKMASK,(WPARAM)LVIS_SELECTED | LVIS_FOCUSED,0);

	return(hWndListView);
}

// Resize the virtual list view window for the edit procedures.
//.............................................................
VOID ResizeTscListView(HWND hWndListView, HWND hWndParent)
{
	RECT  rc;

	GetClientRect(hWndParent, &rc);

	MoveWindow(hWndListView, rc.left,rc.top,rc.right - rc.left,rc.bottom - rc.top,TRUE);
}

// Register the window class to use for viewing the senders
// and recipients of a tsc encrypted file.
//..........................................................
BOOL RegisterSendersWindow()
{
	WNDCLASS	wc;

	wc.style		 = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc	 = (WNDPROC)SendersProc;
	wc.cbClsExtra	 = 0;
	wc.cbWndExtra	 = 0;
	wc.hInstance	 = hInst;
	wc.hIcon		 = LoadIcon(hInst,lpEncFileIcon);
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
    wc.lpszMenuName  = NULL;              
    wc.lpszClassName = lpszTscSenders;
	
	if (bIsWin9x)
	{
		if (!RegisterWin95(&wc))
		{
			return(FALSE);
		}
	}
	else if (!RegisterClass(&wc))
	{
		return(FALSE);
	}
	return(TRUE);
}

// Window procedure for processing the view senders and
// recipients messages.
//......................................................
LRESULT CALLBACK SendersProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL			bResult;

	switch(uMsg)
	{
		case WM_CREATE:
		{
			HMENU			hViewWinMenu;
			MENUITEMINFO	mii;
			
			ShowScrollBar(hWnd,SB_BOTH,TRUE);

			// Disable the move menu item on the window menu.
			//...............................................
			hViewWinMenu = GetSystemMenu(hWnd,FALSE);

			ZeroMemory(&mii,sizeof(MENUITEMINFO));
			mii.cbSize = sizeof(MENUITEMINFO);
			mii.fMask = MIIM_ID | MIIM_STATE;
			mii.fState = MFS_GRAYED;
			mii.wID = -10;
			SetMenuItemInfo(hViewWinMenu,SC_MOVE,FALSE,&mii);

			// Setup the default DC for our window.
			//.....................................
			hDC = GetDC(hWnd);
			if (!hDC)
			{
				goto ErrorCreate;
			}
			// Create a compatable DC and bitmap to hold at least 
			// 200 lines of text.
			//...................................................
			hCompatDC = CreateCompatibleDC(hDC);
			if (!hCompatDC)
			{
			  ErrorCreate:

				if (hCompatDC)
				{
					DeleteDC(hCompatDC);
					hCompatDC = 0;
				}
				if (hbm)
				{
					DeleteObject(hbm);
					hbm = 0;
				}
				return(-1);
			}
			// Setup our fixed pitch font to use.
			//...................................
			SelectObject(hCompatDC,GetStockObject(ANSI_FIXED_FONT));
			GetTextMetrics(hCompatDC,&tm);
			yChar = tm.tmHeight + tm.tmExternalLeading;
			xChar = tm.tmMaxCharWidth;

			// Arbitary max width of client area.
			//...................................
			xClientMax = 78 * xChar;

			// Set the mapping mode.
			//......................
			SetMapMode(hCompatDC,MM_TEXT);

			// Setup a rect for the bitmap.
			//.............................
			BitMapRect.left = 0;
			BitMapRect.top = 0;
			BitMapRect.right = 78 * xChar;
			BitMapRect.bottom = 203 * yChar;

			hbm = CreateCompatibleBitmap(hDC,BitMapRect.right,BitMapRect.bottom);
			if (!hbm)
			{
				goto ErrorCreate;
			}
			// Select the bitmap into the compatible DC.
			//..........................................
			SelectObject(hCompatDC,hbm);

			// Setup the senders and recipients.
			//..................................
			bResult = SetupSendersRecipients();
			if (!bResult)
			{
				goto ErrorCreate;
			}
			bViewWindowDisplayed = TRUE;
		}
		break;

		case WM_SYSCOLORCHANGE:
		{
			bResult = SetupSendersRecipients();
			if (!bResult)
			{
				DestroyWindow(hWnd);
			}
			else
			{
				bSizeWnd = TRUE;
				InvalidateRect(hWnd,NULL,FALSE);
			}
		}
		break;

		case WM_PAINT:
		{
			PRECT	prect;
			BOOL	bHaveUpdate;

			bHaveUpdate = GetUpdateRect(hWnd,NULL,FALSE);

			BeginPaint(hWnd,&ps);

			// Draw the lines of text from the bitmap.
			//........................................
			if (bSizeWnd)
			{
				BitBlt(hDC,ps.rcPaint.left,ps.rcPaint.top,xClient,yClient,
					   hCompatDC,xPos * xInc,yPos * yInc,SRCCOPY);
			}
			if (bScrollWnd)
			{
				prect = &ps.rcPaint;

				BitBlt(ps.hdc,prect->left,prect->top,
					   prect->right - prect->left,
					   prect->bottom - prect->top,
					   hCompatDC,prect->left + (xPos * xChar),
					   prect->top + (yPos * yChar),SRCCOPY);
			}
			if (!bScrollWnd && !bSizeWnd && bHaveUpdate)
			{
				prect = &ps.rcPaint;

				BitBlt(ps.hdc,prect->left,prect->top,
					   prect->right - prect->left,
					   prect->bottom - prect->top,
					   hCompatDC,prect->left + (xPos * xChar),
					   prect->top + (yPos * yChar),SRCCOPY);
			}
			bSizeWnd = FALSE;
			bScrollWnd = FALSE;
			EndPaint(hWnd,&ps);
		}
		break;

		case WM_SIZE:
		{
			// Retrieve the dminension of the client area.
			//............................................
			yClient = HIWORD(lParam);
			xClient = LOWORD(lParam);

			xPos = 0;
			yPos = 0;

			// Determine the maximum vertical scrolling position.
			// The two is added for extra space below the lines
			// of text and the status bar.
			//...................................................
			yMax = max(0,iTotalLines + 2 - (yClient/yChar));

			// Make sure the current vertical scrolling position
			// does not exceed the maximum.
			//..................................................
			yPos = min(yPos,yMax);

			if ((yClient/yChar) < iTotalLines)
			{
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
				sci.nMin = 0;
				sci.nMax = iTotalLines - 1;
				sci.nPage = (yClient/yChar) + 1;
				sci.nPos = yPos;

				EnableScrollBar(hWnd,SB_VERT,ESB_ENABLE_BOTH);
				SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
			}
			else
			{
				EnableScrollBar(hWnd,SB_VERT,ESB_DISABLE_BOTH);
			}
			// Determine the maximum horizontal scrolling position.
			//.....................................................
			xMax = max(0,((xClientMax - xClient)/xChar));

			// Make sure the current horizontal scrolling position
			// does not exceed the maximum.
			//....................................................
			xPos = min(xPos,xMax);
			
			if (xMax < 78)
			{
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS | SIF_RANGE | SIF_PAGE;
				sci.nMin = 0;
				sci.nMax = 77;
				sci.nPage = (xClient / xChar) + 1;
				sci.nPos = xPos;

				EnableScrollBar(hWnd,SB_HORZ,ESB_ENABLE_BOTH);
				SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);
			}
			else
			{
				EnableScrollBar(hWnd,SB_HORZ,ESB_DISABLE_BOTH);
			}
			// Redisplay the senders and recipients.
			//......................................
			bSizeWnd = TRUE;
			InvalidateRect(hWnd,NULL,FALSE);
		}
		break;

		case WM_CLOSE:
		{
			DestroyWindow(hWnd);
		}
		break;

		case WM_DESTROY:
		{
			if (hCompatDC)
			{
				DeleteDC(hCompatDC);
				hCompatDC = 0;
			}
			if (hbm)
			{
				DeleteObject(hbm);
				hbm = 0;
			}
			// Notify the view tsc encrypted file procedure it
			// can continue.
			//................................................
			SetEvent(hSendersEvent);

			bViewWindowDisplayed = FALSE;
		}
		break;

		case WM_HSCROLL:
		{
			switch (LOWORD(wParam))
			{
				// We clicked the shaft left of the scroll box.
				//.............................................
				case SB_PAGELEFT:
				{
					xInc = -8;
					break;
				}
				// We clicked the shaft right of the scroll box.
				//..............................................
				case SB_PAGERIGHT:
				{
					xInc = 8;
					break;
				}
				// We clicked the left arrow.
				//...........................
				case SB_LINELEFT:
				{
					xInc = -1;
					break;
				}
				// We clicked the right arrow.
				//............................
				case SB_LINERIGHT:
				{
					xInc = 1;
					break;
				}
				// We dragged the scroll bar.
				//...........................
				case SB_THUMBTRACK:
				{
					xInc = HIWORD(wParam) - xPos;
					break;
				}
				default:
					xInc = 0;
			}
			// If applying the horizontal scrolling increment does not
			// take the scrolling position out of the scrolling range,
			// increment the scrolling position, adjust the position
			// of the scroll box, and update the window.
			//........................................................
			if (xInc = max(-xPos, min(xInc, xMax-xPos)))
			{
				bScrollWnd = TRUE;
				xPos += xInc;
				ScrollWindowEx(hWnd,-xChar * xInc,0,NULL,NULL,
							   NULL,NULL,SW_INVALIDATE | SW_ERASE);
				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS;
				sci.nPos = xPos;
				SetScrollInfo(hWnd,SB_HORZ,&sci,TRUE);
				UpdateWindow(hWnd);
			}
			break;
		}
	
		case WM_VSCROLL:
		{
			switch(LOWORD(wParam))
			{
				// We clicked the shaft above the scroll box.
				//...........................................
				case SB_PAGEUP:
				{
					yInc = min(-1,-yClient / yChar);
					break;
				}
				// We clicked the shaft below the scroll box.
				//...........................................
				case SB_PAGEDOWN:
				{
					yInc = max(1,yClient / yChar);
					break;
				}
				// We clicked the top arrow.
				//..........................
				case SB_LINEUP:
				{
					yInc = -1;
					break;
				}
				// We clicked the bottom arrow.
				//.............................
				case SB_LINEDOWN:
				{
					yInc = 1;
					break;
				}
				// We dragged the scroll box.
				//...........................
				case SB_THUMBTRACK:
				{
					yInc = HIWORD(wParam) - yPos;
					break;
				}
				// We used the home key to go to the top.
				//.......................................
				case SB_TOP:
				{
					yInc = -yMax;
					break;
				}
				// We used the end key to go to the bottom.
				//.........................................
				case SB_BOTTOM:
				{
					yInc = yMax;
					break;
				}

				default:
					yInc = 0;
			}
			// If applying the vertical scrolling increment does not
			// take the scrolling position out of the scrolling range,
			// increment the scrolling position, adjust the position
			// of the scroll box, and update the window.
			//.......................................................
			if (yInc = max(-yPos, min(yInc, yMax - yPos)))
			{
				bScrollWnd = TRUE;

				yPos += yInc;
				
				// Only scroll the window if yInc is less than yClient.
				// If greater or equal to yClient invalidate the whole
				// rectangle and redraw it.
				//....................................................
				if (abs(yInc) < yClient)
				{
					ScrollWindowEx(hWnd,0,-yChar * yInc,NULL,NULL,
								   NULL,NULL,SW_INVALIDATE | SW_ERASE);
				}
				else
				{
					InvalidateRect(hWnd,NULL,TRUE);
				}

				sci.cbSize = sizeof(SCROLLINFO);
				sci.fMask = SIF_POS;
				sci.nPos = yPos;
				SetScrollInfo(hWnd,SB_VERT,&sci,TRUE);
				UpdateWindow(hWnd);
			}
			break;
		}
		// Capture the keyboard keys for manipulating the scroll bars.
		//............................................................
		case WM_KEYDOWN:
		{
			WORD	wScrollAction = 0xFFFF;
			UINT	ScrollMsg = WM_VSCROLL;

			switch(wParam)
			{
				case VK_UP:
				{
					wScrollAction = SB_LINEUP;
					break;
				}
				case VK_DOWN:
				{
					wScrollAction = SB_LINEDOWN;
					break;
				}
				case VK_PRIOR:
				{
					wScrollAction = SB_PAGEUP;
					break;
				}
				case VK_NEXT:
				{
					wScrollAction = SB_PAGEDOWN;
					break;
				}
				case VK_HOME:
				{
					wScrollAction = SB_TOP;
					break;
				}
				case VK_END:
				{
					wScrollAction = SB_BOTTOM;
					break;
				}
				// Take care of the horizontal scroll bar.
				//........................................
				case VK_LEFT:
				{
					wScrollAction = SB_LINELEFT;
					ScrollMsg = WM_HSCROLL;
					break;
				}
				case VK_RIGHT:
				{
					wScrollAction = SB_LINERIGHT;
					ScrollMsg = WM_HSCROLL;
					break;
				}
				case VK_ESCAPE:
				{
					DestroyWindow(hWnd);
					break;
				}
			}
			if (wScrollAction != -1)
			{
				SendMessage(hWnd,ScrollMsg,MAKELONG(wScrollAction,0),0L);
			}
			break;
		}		
        default:
			return(DefWindowProc(hWnd, uMsg, wParam, lParam));
	}
	return(0L);
}
